//
//  CRSceneItemShadowGenerator.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/2/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

@class CRShadowGenerator;

//////////////////////////////////////////////////////////////////////
// THis enum is used by number of scene items
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRShadowsNone		= 0x00,
	CRShadowsInternal	= 0x01,
	CRShadowsExternal	= 0x10,
	CRShadowsInherited	= 0xFF,
	
	CRShadowsFull		= CRShadowsInternal | CRShadowsExternal,
} CRShadowsMode;

//////////////////////////////////////////////////////////////////////
// Frame shadow generator
// Wraps basic CRShadowGenerator and adjusts shadow settings with
// CRScene parameters
//////////////////////////////////////////////////////////////////////
extern NSString* const CRSceneItemShadowGeneratorDistanceToPlainKey;

@interface CRSceneItemShadowGenerator : CRImageProcessor
{
}

@property (nonatomic, assign) CGFloat distanceToPlane; // distance to shadow plane, rules shadow blur and offset

+ (id)shadow;

@end